# -*- coding: utf-8 -*-
"""
Created on Tue Nov 26 11:39:41 2019

@author: young11
"""

#!/usr/bin/env python

from ecmwfapi import ECMWFDataServer
server = ECMWFDataServer()
    
def retrieve_tigge_data():
    dates = ['2018-12-04','2018-12-05']
    times = ['00']
    for date in dates:
         for time in times:
             target = 'ecmwf_sfc_%s_%s.grb' % (date, time)
             tigge_pf_sfc_request(date, time, target)


def tigge_pf_sfc_request(date, time, target):
    '''
       A TIGGE request for perturbed forecast, sfc, ECMWF Center.
       Please note that a subset of the available data is requested below.
       Change the keywords below to adapt it to your needs. (ie to add more parameters, or numbers etc)
    '''
    server.retrieve({
    "class": "ti",
    "dataset": "tigge",
    "date": date,
    "expver": "prod",
    "grid": "0.5/0.5",
    "levtype": "sfc",
    "number": "1/2/3/4/5/6/7/8/9/10/11/12/13/14/15/16/17/18/19/20/21/22/23/24/25/26/27/28/29/30/31/32/33/34/35/36/37/38/39/40/41/42/43/44/45/46/47/48/49/50",
    "origin": "ecmf",
    "param": "228228",
    "step": "0/6/12/18/24/30/36/42/48/54/60/66/72",
    'area': "31.5/29.5/31/30",
    "type": "pf",
    'target': target,
    'time': time,
    })
 
if __name__ == '__main__':
    retrieve_tigge_data()